/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.util.Utils;

public class CfgItemAddrSpace {
    public int address;
    public int size;

    public String checkBounds() {
        return this.checkBounds(0, 65535);
    }

    public String checkBounds(CfgItemAddrSpace cfgItemAddrSpace) {
        return this.checkBounds(cfgItemAddrSpace.address, cfgItemAddrSpace.getLastAddress());
    }

    public String checkBounds(int n, int n2) {
        if (this.size <= 0) {
            return "Negative or null size (" + this.size + ")";
        }
        if (this.address < n) {
            return "Invalid start address $" + Utils.HEX(4, this.address) + " - it must be greater or equal to $" + Utils.HEX4(n);
        }
        if (this.address > n2) {
            return "Invalid start address $" + Utils.HEX(4, this.address) + " - it cannot exceed $" + Utils.HEX4(n2);
        }
        if (this.getLastAddress() > n2) {
            return "Invalid end address $" + Utils.HEX(4, this.getLastAddress()) + " - the maximum allowed is $" + Utils.HEX4(n2);
        }
        return null;
    }

    public int getLastAddress() {
        return this.address + this.size - 1;
    }
}

